<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
    }
    
    public function create_user($data) {
        $this->db->trans_start();
        
        // Encrypt password
        $data['password'] = password_hash($data['password'], PASSWORD_BCRYPT, ['cost' => 12]);
        
        // Insert user
        $this->db->insert('users', $data);
        $user_id = $this->db->insert_id();
        
        // Create profile
        $profile_data = array('user_id' => $user_id);
        $this->db->insert('user_profiles', $profile_data);
        
        $this->db->trans_complete();
        
        return $this->db->trans_status() ? $user_id : false;
    }
    
    public function authenticate($email, $password) {
        // Use prepared statement for security
        $sql = "SELECT id, email, password, role, is_active, login_attempts FROM users WHERE email = ? AND is_active = 1 LIMIT 1";
        $query = $this->db->query($sql, array($email));
        
        if ($query->num_rows() == 1) {
            $user = $query->row();
            
            // Check if account is locked
            if ($user->login_attempts >= 5) {
                return false;
            }
            
            if (password_verify($password, $user->password)) {
                // Update last login
                $this->db->where('id', $user->id);
                $this->db->update('users', array(
                    'last_login' => date('Y-m-d H:i:s'),
                    'login_attempts' => 0
                ));
                
                return $user;
            }
        }
        
        return false;
    }
    
    public function get_by_email($email) {
        return $this->db->get_where('users', array('email' => $email))->row();
    }
    
    public function get_profile($user_id) {
        $this->db->select('up.*, u.email, u.role');
        $this->db->from('user_profiles up');
        $this->db->join('users u', 'u.id = up.user_id');
        $this->db->where('up.user_id', $user_id);
        return $this->db->get()->row();
    }
    
    public function update_profile($user_id, $data) {
        $data['is_complete'] = $this->is_profile_complete($data);
        $data['updated_at'] = date('Y-m-d H:i:s');
        
        $this->db->where('user_id', $user_id);
        return $this->db->update('user_profiles', $data);
    }
    
    private function is_profile_complete($data) {
        $required = ['full_name', 'dob', 'gender', 'phone', 'specialization', 'tenth_marks', 'twelfth_marks'];
        
        foreach ($required as $field) {
            if (empty($data[$field])) {
                return false;
            }
        }
        return true;
    }
    
    public function increment_login_attempts($user_id) {
        $this->db->set('login_attempts', 'login_attempts + 1', FALSE);
        $this->db->where('id', $user_id);
        $this->db->update('users');
    }
    
    public function reset_login_attempts($user_id) {
        $this->db->where('id', $user_id);
        $this->db->update('users', array('login_attempts' => 0));
    }
    
    public function email_exists($email) {
        $this->db->where('email', $email);
        return $this->db->count_all_results('users') > 0;
    }
}