<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Application_model extends CI_Model {
    
    public function submit_application($user_id, $course_id) {
        $this->db->trans_start();
        
        // Check for existing application
        $existing = $this->db->get_where('applications', array(
            'user_id' => $user_id,
            'course_id' => $course_id
        ))->row();
        
        if ($existing) {
            return array('success' => false, 'message' => 'Already applied for this course');
        }
        
        // Check course availability
        $course = $this->db->query(
            "SELECT available_seats FROM courses WHERE id = ? AND available_seats > 0 FOR UPDATE",
            array($course_id)
        )->row();
        
        if (!$course) {
            return array('success' => false, 'message' => 'Course is full');
        }
        
        // Generate application number
        $application_number = generate_application_number();
        
        // Insert application
        $application_data = array(
            'user_id' => $user_id,
            'course_id' => $course_id,
            'application_number' => $application_number
        );
        
        $this->db->insert('applications', $application_data);
        $application_id = $this->db->insert_id();
        
        // Update seat count
        $this->db->query(
            "UPDATE courses SET available_seats = available_seats - 1 WHERE id = ?",
            array($course_id)
        );
        
        $this->db->trans_complete();
        
        if ($this->db->trans_status()) {
            return array(
                'success' => true,
                'application_id' => $application_id,
                'application_number' => $application_number
            );
        } else {
            return array('success' => false, 'message' => 'Failed to submit application');
        }
    }
    
    public function get_user_applications($user_id) {
        $this->db->select('a.*, c.course_name, c.course_code, c.specialization');
        $this->db->from('applications a');
        $this->db->join('courses c', 'c.id = a.course_id');
        $this->db->where('a.user_id', $user_id);
        $this->db->order_by('a.application_date', 'DESC');
        return $this->db->get()->result();
    }
    
    public function get_application_detail($application_id) {
        $this->db->select('a.*, c.*, up.full_name, up.twelfth_marks, u.email');
        $this->db->from('applications a');
        $this->db->join('courses c', 'c.id = a.course_id');
        $this->db->join('user_profiles up', 'up.user_id = a.user_id');
        $this->db->join('users u', 'u.id = a.user_id');
        $this->db->where('a.id', $application_id);
        return $this->db->get()->row();
    }
    
    public function update_status($application_id, $status, $remarks = null) {
        $update_data = array(
            'status' => $status,
            'remarks' => $remarks,
            'reviewed_at' => date('Y-m-d H:i:s'),
            'reviewed_by' => $this->session->userdata('user_id')
        );
        
        $this->db->where('id', $application_id);
        return $this->db->update('applications', $update_data);
    }
    
    public function get_recent_applications($limit = 10) {
        $this->db->select('a.*, c.course_name, up.full_name');
        $this->db->from('applications a');
        $this->db->join('courses c', 'c.id = a.course_id');
        $this->db->join('user_profiles up', 'up.user_id = a.user_id');
        $this->db->order_by('a.application_date', 'DESC');
        $this->db->limit($limit);
        return $this->db->get()->result();
    }
}