<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('is_logged_in')) {
    function is_logged_in() {
        $CI =& get_instance();
        return $CI->session->userdata('logged_in') === TRUE;
    }
}

if (!function_exists('require_login')) {
    function require_login($redirect = 'auth/login') {
        if (!is_logged_in()) {
            redirect($redirect);
        }
    }
}

if (!function_exists('upload_file')) {
    function upload_file($field_name, $config) {
        $CI =& get_instance();
        $CI->load->library('upload', $config);
        
        if (!$CI->upload->do_upload($field_name)) {
            return array('success' => false, 'error' => $CI->upload->display_errors());
        } else {
            return array('success' => true, 'data' => $CI->upload->data());
        }
    }
}

if (!function_exists('validate_email_domain')) {
    function validate_email_domain($email) {
        $allowed_domains = array('gmail.com', 'yahoo.com', 'outlook.com', 'hotmail.com');
        $domain = substr(strrchr($email, "@"), 1);
        return in_array($domain, $allowed_domains);
    }
}