<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->helper('admission');
        require_login();
        $this->load->model('User_model');
        $this->load->library(['form_validation', 'upload', 'Security_lib']);
    }
    
    public function index() {
        $user_id = $this->session->userdata('user_id');
        $data['profile'] = $this->User_model->get_profile($user_id);
        $data['title'] = 'My Profile';
        
        $this->load->view('templates/header', $data);
        $this->load->view('profile/index', $data);
        $this->load->view('templates/footer');
    }
    
    public function bio_data() {
        $user_id = $this->session->userdata('user_id');
        
        $this->form_validation->set_rules('full_name', 'Full Name', 'required|min_length[3]|max_length[100]|trim');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'required');
        $this->form_validation->set_rules('gender', 'Gender', 'required|in_list[male,female,other]');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required|regex_match[/^[0-9]{10}$/]');
        $this->form_validation->set_rules('address', 'Address', 'required|min_length[10]');
        $this->form_validation->set_rules('specialization', 'Specialization', 'required|in_list[science,commerce,arts]');
        $this->form_validation->set_rules('tenth_marks', '10th Marks', 'required|numeric|greater_than_equal_to[0]|less_than_equal_to[100]');
        $this->form_validation->set_rules('twelfth_marks', '12th Marks', 'required|numeric|greater_than_equal_to[0]|less_than_equal_to[100]');
        
        if ($this->form_validation->run() === TRUE) {
            $profile_data = [
                'full_name' => sanitize_input($this->input->post('full_name')),
                'dob' => $this->input->post('dob'),
                'gender' => $this->input->post('gender'),
                'phone' => sanitize_input($this->input->post('phone')),
                'address' => sanitize_input($this->input->post('address')),
                'specialization' => $this->input->post('specialization'),
                'tenth_marks' => $this->input->post('tenth_marks'),
                'twelfth_marks' => $this->input->post('twelfth_marks'),
                'updated_at' => date('Y-m-d H:i:s')
            ];
            
            if ($this->User_model->update_profile($user_id, $profile_data)) {
                $this->security_lib->audit_log('profile_updated', ['user_id' => $user_id]);
                $this->session->set_flashdata('success', 'Profile updated successfully!');
                redirect('profile/certificates');
            } else {
                $this->session->set_flashdata('error', 'Failed to update profile.');
            }
        }
        
        $data['profile'] = $this->User_model->get_profile($user_id);
        $data['title'] = 'Bio Data';
        
        $this->load->view('templates/header', $data);
        $this->load->view('profile/bio_data', $data);
        $this->load->view('templates/footer');
    }
    
    public function certificates() {
        $user_id = $this->session->userdata('user_id');
        $profile = $this->User_model->get_profile($user_id);
        
        // Check if bio data is complete
        if (!$profile->tenth_marks || !$profile->twelfth_marks) {
            $this->session->set_flashdata('error', 'Please complete bio data first.');
            redirect('profile/bio-data');
        }
        
        $config['upload_path'] = './uploads/certificates/';
        $config['allowed_types'] = 'pdf|jpg|jpeg|png';
        $config['max_size'] = 2048; // 2MB
        $config['encrypt_name'] = TRUE;
        $config['remove_spaces'] = TRUE;
        
        $this->upload->initialize($config);
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $update_data = [];
            $errors = [];
            
            // Upload 10th certificate
            if (!empty($_FILES['tenth_certificate']['name'])) {
                if ($this->upload->do_upload('tenth_certificate')) {
                    $upload_data = $this->upload->data();
                    $update_data['tenth_certificate'] = $upload_data['file_name'];
                } else {
                    $errors[] = $this->upload->display_errors();
                }
            }
            
            // Upload 12th certificate
            if (!empty($_FILES['twelfth_certificate']['name'])) {
                if ($this->upload->do_upload('twelfth_certificate')) {
                    $upload_data = $this->upload->data();
                    $update_data['twelfth_certificate'] = $upload_data['file_name'];
                } else {
                    $errors[] = $this->upload->display_errors();
                }
            }
            
            if (!empty($update_data)) {
                $update_data['updated_at'] = date('Y-m-d H:i:s');
                
                if ($this->User_model->update_profile($user_id, $update_data)) {
                    $this->security_lib->audit_log('certificates_uploaded', ['user_id' => $user_id]);
                    $this->session->set_flashdata('success', 'Certificates uploaded successfully!');
                    redirect('courses');
                }
            }
            
            if (!empty($errors)) {
                $this->session->set_flashdata('error', implode('<br>', $errors));
            }
        }
        
        $data['profile'] = $profile;
        $data['title'] = 'Upload Certificates';
        
        $this->load->view('templates/header', $data);
        $this->load->view('profile/certificates', $data);
        $this->load->view('templates/footer');
    }
}