<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Application extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->helper('admission');
        require_login();
        require_profile_complete();
        $this->load->model(['User_model', 'Course_model', 'Application_model']);
        $this->load->library('Security_lib');
    }
    
    public function courses() {
        $user_id = $this->session->userdata('user_id');
        $profile = $this->User_model->get_profile($user_id);
        
        if (!$profile->tenth_certificate || !$profile->twelfth_certificate) {
            $this->session->set_flashdata('error', 'Please upload certificates first.');
            redirect('profile/certificates');
        }
        
        $data['courses'] = $this->Course_model->get_eligible_courses(
            $profile->specialization, 
            $profile->twelfth_marks
        );
        $data['profile'] = $profile;
        $data['title'] = 'Available Courses';
        
        $this->load->view('templates/header', $data);
        $this->load->view('application/courses', $data);
        $this->load->view('templates/footer');
    }
    
    public function course_detail($course_id) {
        $data['course'] = $this->Course_model->get_course_with_stats($course_id);
        $data['title'] = $data['course']->course_name;
        
        $this->load->view('templates/header', $data);
        $this->load->view('application/course_detail', $data);
        $this->load->view('templates/footer');
    }
    
    public function apply($course_id) {
        $user_id = $this->session->userdata('user_id');
        
        // Check if already applied to this course
        $existing = $this->Application_model->get_user_applications($user_id);
        foreach ($existing as $app) {
            if ($app->course_id == $course_id && $app->status != 'rejected') {
                $this->session->set_flashdata('error', 'You have already applied for this course.');
                redirect('applications');
            }
        }
        
        $result = $this->Application_model->submit_application($user_id, $course_id);
        
        if ($result['success']) {
            $this->security_lib->audit_log('application_submitted', [
                'user_id' => $user_id,
                'course_id' => $course_id,
                'application_id' => $result['application_id']
            ]);
            
            $this->session->set_flashdata('success', 
                'Application submitted successfully! Your application number is: ' . $result['application_number']
            );
        } else {
            $this->session->set_flashdata('error', $result['message']);
        }
        
        redirect('applications');
    }
    
    public function my_applications() {
        $user_id = $this->session->userdata('user_id');
        $data['applications'] = $this->Application_model->get_user_applications($user_id);
        $data['title'] = 'My Applications';
        
        $this->load->view('templates/header', $data);
        $this->load->view('application/my_applications', $data);
        $this->load->view('templates/footer');
    }
    
    public function view($application_number) {
        $data['application'] = $this->Application_model->get_application_detail($application_number);
        $data['title'] = 'Application Details';
        
        $this->load->view('templates/header', $data);
        $this->load->view('application/view', $data);
        $this->load->view('templates/footer');
    }
}