<?php

/**
 * Copyright (c) 2022-present Tectalic (https://tectalic.com)
 *
 * For copyright and license information, please view the LICENSE file that was distributed with this source code.
 *
 * Please see the README.md file for usage instructions.
 */

declare(strict_types=1);

namespace Tectalic\OpenAi\Models\Embeddings;

use Tectalic\OpenAi\Models\AbstractModel;

final class CreateResponse extends AbstractModel
{
    /**
     * List of required property names.
     *
     * These properties must all be set when this Model is instantiated.
     */
    protected const REQUIRED = ['object', 'model', 'data', 'usage'];

    /**
     * The object type, which is always "embedding".
     *
     * @var string
     */
    public $object;

    /**
     * The name of the model used to generate the embedding.
     *
     * @var string
     */
    public $model;

    /**
     * The list of embeddings generated by the model.
     *
     * @var \Tectalic\OpenAi\Models\Embeddings\CreateResponseDataItem[]
     */
    public $data;

    /**
     * The usage information for the request.
     *
     * @var \Tectalic\OpenAi\Models\Embeddings\CreateResponseUsage
     */
    public $usage;
}
